# Юзабилити-тестирование платформы для персонализированного адаптивного электронного обучения

## Цель тестирования

Целью юзабилити-тестирования является оценка удобства использования корпоративной платформы для адаптивного электронного обучения, проверка интуитивности навигации, восприятия персонализированного контента и функциональности инструментов, а также формирование рекомендаций по повышению эффективности пользовательского опыта сотрудников.

## Описание тестируемого компонента

Тестируемым компонентом является интерфейс IT-продукта, предназначенного для реализации персонализированных дидактических материалов.

Платформа включает следующие ключевые экраны и функциональные блоки:

* дашборд с персональной образовательной траекторией и прогрессом обучения;
* экран доступных курсов и обучающих модулей с индивидуальными рекомендациями;
* экран отдельных модулей с интерактивными заданиями и мультимедийным контентом;
* элементы фильтрации и поиска модулей по компетенциям и уровням подготовки;
* аналитические панели с визуализацией прогресса и результатов диагностики.

Тестирование проводилось на высокодетализированном прототипе интерфейса.

## Методология тестирования

### Формат тестирования

Использовалось дистанционное юзабилити-тестирование по заранее разработанным сценариям.
Участникам предлагалось выполнять типовые действия, характерные для сотрудника корпоративного обучения, и давать комментарии о возникающих затруднениях.

### Участники

В тестировании приняли участие 10 сотрудников компании, имеющих опыт прохождения онлайн-курсов и использования образовательных платформ.

### Пользовательские задачи

В ходе тестирования участникам предлагалось:

1. Открыть платформу и просмотреть персональный дашборд с образовательной траекторией.
2. Отфильтровать обучающие модули по компетенциям или уровням сложности.
3. Выбрать модуль «Управление проектами» и перейти к его описанию.
4. Ознакомиться с информацией о прогрессе и рекомендуемом времени обучения.
5. Перейти к списку уроков и интерактивных заданий модуля.
6. Определить, какой урок был пройден последним и какие материалы требуют повторного изучения.

## Основные наблюдения

### Положительные моменты

* Интерфейс дашборда воспринимается как современный, функциональный и визуально структурированный.
* Персонализированные рекомендации и карточки модулей хорошо различимы и содержат ключевую информацию (название, уровень сложности, длительность).
* Цветовое кодирование модулей помогает быстро ориентироваться в контенте.
* Пользователи легко находят экран модуля и список заданий.
* Элементы визуализации прогресса мотивируют к продолжению обучения.

### Обнаруженные проблемы

* Назначение некоторых иконок управления и индикаторов статуса не всегда очевидно без пояснений.
* Не всем пользователям сразу понятно, завершён ли модуль или находится в процессе прохождения.
* Графики активности и прогресса требуют поясняющего текста для корректной интерпретации.
* Горизонтальная прокрутка фильтров модулей иногда не воспринимается пользователями.
* Индикатор текущего задания/урока недостаточно заметен.

## Выводы

По результатам юзабилити-тестирования можно сделать вывод, что интерфейс платформы в целом интуитивно понятен и удобен для сотрудников корпоративного обучения. Пользователи успешно выполняют основные сценарии взаимодействия и положительно оценивают визуальное оформление.

Вместе с тем выявлены элементы интерфейса, требующие доработки для повышения ясности отображения прогресса и функциональных возможностей, что позволит улучшить восприятие персонализированного контента и эффективность обучения.

## Рекомендации по улучшению

На основании выявленных проблем рекомендуется:

* Добавить текстовые подсказки или подписи к иконкам и функциональным элементам.
* Явно обозначить статус модуля (в процессе / завершён).
* Дополнить графики прогресса пояснительными подписями или легендой.
* Сделать индикатор текущего урока/задания более заметным.
* Усилить визуальные подсказки для элементов фильтрации и поиска модулей.
